from pyparsing import Optional, Literal

from codeable_detectors.basic_detectors import AtLeastOneFileMatchesDetector
from codeable_detectors.detector_context import DetectorContext
from codeable_detectors.evidences import FailedEvidence, LinkEvidence
from codeable_detectors.pyparsing_patterns import ID, round_braces_block


def detect_go_import(ctx, package_name):
    matches = []
    import_statement_matches = ctx.matches_pattern("import" + round_braces_block)
    for import_statement_match in import_statement_matches:
        import_matches = DetectorContext(import_statement_match).matches_pattern(Optional(ID) +
                                                                               Literal("\"") + Literal(
            package_name) + Literal("\""))
        for match in import_matches:
            if match.text.strip().startswith("\""):
                match.update_keyword_args(package_name=package_name)
            else:
                alias = match.text[:match.text.find("\"")].strip()
                match.update_keyword_args(package_name=package_name, alias=alias)
            matches.append(match)

    import_matches = ctx.matches_pattern("import" + Optional(ID) + Literal(package_name))
    for match in import_matches:
        if match.text.strip().startswith(package_name):
            match.update_keyword_args(package_name=package_name)
        else:
            alias = match.text[:match.text.search(package_name)].strip()
            match.update_keyword_args(package_name=package_name, alias=alias)
        matches.append(match)
    return matches


class GoImportLink(AtLeastOneFileMatchesDetector):
    def __init__(self, package_name):
        super().__init__()
        self.file_endings = ["go"]
        self.package_name = package_name

    def detect_in_context(self, ctx, **kwargs):
        import_matches = detect_go_import(ctx, self.package_name)
        if not import_matches:
            return FailedEvidence("go '" + str(self.package_name) + "' import not found")
        return LinkEvidence(import_matches).set_properties(kwargs=kwargs)
